/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWListUpdateListener;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.images.VWBaseImageLoader;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VWAddRemovePanel
extends JPanel
implements ListSelectionListener,
ActionListener,
IVWMouseActionListener,
DocumentListener,
KeyListener,
FocusListener {
    public static final int ADD_BUTTON = 1;
    public static final int ADD_ALL_BUTTON = 2;
    public static final int REMOVE_BUTTON = 4;
    public static final int REMOVE_ALL_BUTTON = 8;
    public static final int MOVE_ALL_BUTTONS = 10;
    public static final int UP_BUTTON = 16;
    public static final int DOWN_BUTTON = 32;
    public static final int UP_DOWN_BUTTONS = 48;
    public static final int ENABLE_TYPE_AHEAD = 128;
    public static final int SORT_AVAILABLE = 256;
    public static final int SORT_SELECTED = 512;
    public static final int SORT_BOTH = 768;
    public static final int MAINTAIN_AVAILABLE_SORTED = 1024;
    public static final int MAINTAIN_SELECTED_SORTED = 2048;
    public static final int MAINTAIN_BOTH_SORTED = 3072;
    protected JTextField m_typeAheadName = null;
    protected JLabel m_availableLabel = null;
    protected JList m_availableList = null;
    protected AbstractButton m_addButton = null;
    protected AbstractButton m_addAllButton = null;
    protected AbstractButton m_removeButton = null;
    protected AbstractButton m_removeAllButton = null;
    protected JLabel m_selectedLabel = null;
    protected JList m_selectedList = null;
    protected AbstractButton m_moveUpButton = null;
    protected AbstractButton m_moveDownButton = null;
    protected JPanel m_optionPanel = null;
    protected boolean m_enableTypeAhead = false;
    protected boolean m_bShowMoveAllButtons = false;
    protected boolean m_bShowUpDownButtons = false;
    protected boolean m_bSortAvailable = false;
    protected boolean m_bSortSelected = false;
    protected boolean m_bMaintainAvailableSorted = false;
    protected boolean m_bMaintainSelectedSorted = false;
    protected Object[] m_hiddenAvailableItems = null;
    protected boolean m_bIsModified = false;
    protected EventListenerList m_listUpdateListenerList = null;
    protected Container m_parentContainer = null;
    protected VWSession m_vwSession = null;

    public VWAddRemovePanel(int nFlags) {
        this.initControls(nFlags);
    }

    public VWAddRemovePanel(int nFlags, JPanel optionPanel) {
        this.m_optionPanel = optionPanel;
        this.initControls(nFlags);
    }

    public VWAddRemovePanel(int nFlags, Container parentContainer, VWSession vwSession) {
        this.m_parentContainer = parentContainer;
        this.m_vwSession = vwSession;
        this.initControls(nFlags);
    }

    public void enableAllSorting(boolean bEnable) {
        int nFlags = 0;
        if (bEnable) {
            nFlags = 3840;
        }
        this.enableSorting(nFlags);
    }

    public void enableSorting(int nSortFlags) {
        VWSortedListModel listModel;
        boolean bOriginalSortAvailable = this.m_bSortAvailable;
        boolean bOriginalSortSelected = this.m_bSortSelected;
        this.m_bSortAvailable = false;
        this.m_bSortSelected = false;
        this.m_bMaintainAvailableSorted = false;
        this.m_bMaintainSelectedSorted = false;
        if ((nSortFlags & 0x100) == 256 || (nSortFlags & 0x300) == 768) {
            this.m_bSortAvailable = true;
        }
        if ((nSortFlags & 0x200) == 512 || (nSortFlags & 0x300) == 768) {
            this.m_bSortSelected = true;
        }
        if ((nSortFlags & 0x400) == 1024 || (nSortFlags & 0xC00) == 3072) {
            this.m_bMaintainAvailableSorted = true;
        }
        if ((nSortFlags & 0x800) == 2048 || (nSortFlags & 0xC00) == 3072) {
            this.m_bMaintainSelectedSorted = true;
        }
        if (!bOriginalSortAvailable && this.m_bSortAvailable && this.m_availableList != null && (listModel = (VWSortedListModel)this.m_availableList.getModel()) != null) {
            listModel.sort();
        }
        if (!bOriginalSortSelected && this.m_bSortSelected && this.m_selectedList != null && (listModel = (VWSortedListModel)this.m_selectedList.getModel()) != null) {
            listModel.sort();
        }
    }

    public Object[] getAvailableItems() {
        try {
            ListModel listModel = this.m_availableList.getModel();
            Object[] items = new Object[listModel.getSize()];
            for (int i = 0; i < listModel.getSize(); ++i) {
                items[i] = listModel.getElementAt(i);
            }
            return items;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public Object[] getSelectedItems() {
        try {
            ListModel listModel = this.m_selectedList.getModel();
            Object[] items = new Object[listModel.getSize()];
            for (int i = 0; i < listModel.getSize(); ++i) {
                items[i] = listModel.getElementAt(i);
            }
            return items;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public String[] getSelectedStringItems() {
        try {
            ListModel listModel = this.m_selectedList.getModel();
            int size = listModel.getSize();
            if (size > 0) {
                String[] items = new String[size];
                for (int i = 0; i < size; ++i) {
                    items[i] = listModel.getElementAt(i).toString();
                }
                return items;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public Object[] getSelectedItemsInAvailableList() {
        try {
            int[] indices = this.m_availableList.getSelectedIndices();
            if (indices.length == 0) {
                return null;
            }
            VWSortedListModel listModel = (VWSortedListModel)this.m_availableList.getModel();
            Object[] items = new Object[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                items[i] = listModel.getElementAt(indices[i]);
            }
            return items;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public Object[] getSelectedItemsInSelectedList() {
        try {
            int[] indices = this.m_selectedList.getSelectedIndices();
            if (indices.length == 0) {
                return null;
            }
            VWSortedListModel listModel = (VWSortedListModel)this.m_selectedList.getModel();
            Object[] items = new Object[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                items[i] = listModel.getElementAt(indices[i]);
            }
            return items;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public void initializeLists(Object[] availableItems, Object[] selectedItems) {
        try {
            if (this.m_enableTypeAhead && this.m_typeAheadName != null) {
                this.m_typeAheadName.setText("");
                this.m_typeAheadName.requestFocus();
            }
            this.setAvailableAndSelectedItems(availableItems, selectedItems);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void initializeLists(Object[] availableItems, Object[] selectedItems, Object[] hiddenAvailableItems) {
        if (hiddenAvailableItems != null && hiddenAvailableItems.length > 0) {
            this.m_hiddenAvailableItems = new Object[hiddenAvailableItems.length];
            System.arraycopy(hiddenAvailableItems, 0, this.m_hiddenAvailableItems, 0, hiddenAvailableItems.length);
        }
        this.initializeLists(availableItems, selectedItems);
    }

    public void setItemName(String name) {
        this.setAvailableItemName(name);
        this.setSelectedItemName(name);
    }

    public void setAvailableItemName(String name) {
        if (this.m_availableLabel == null) {
            this.m_availableLabel = new JLabel();
            this.m_availableLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        String availableString = null;
        availableString = this.m_enableTypeAhead ? VWResource.s_typeAheadLabel : name;
        this.m_availableLabel.setText(availableString);
        VWAccessibilityHelper.setAccessibility(this.m_availableLabel, null, availableString, availableString);
        VWAccessibilityHelper.setAccessibility(this.m_availableList, null, availableString, availableString);
    }

    public void setSelectedItemName(String name) {
        if (this.m_selectedLabel == null) {
            this.m_selectedLabel = new JLabel();
            this.m_selectedLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        this.m_selectedLabel.setText(name);
        VWAccessibilityHelper.setAccessibility(this.m_selectedLabel, null, name, name);
        VWAccessibilityHelper.setAccessibility(this.m_selectedList, null, name, name);
    }

    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        if (listCellRenderer == null) {
            return;
        }
        if (this.m_availableList != null) {
            this.m_availableList.setCellRenderer(listCellRenderer);
        }
        if (this.m_selectedList != null) {
            this.m_selectedList.setCellRenderer(listCellRenderer);
        }
    }

    public boolean isModified() {
        return this.m_bIsModified;
    }

    public void removeAllItems() {
        this.m_availableList.setModel(new VWSortedListModel());
        this.m_selectedList.setModel(new VWSortedListModel());
    }

    public void removeReferences() {
        this.m_availableLabel = null;
        this.m_selectedLabel = null;
        this.m_typeAheadName = null;
        if (this.m_availableList != null) {
            this.m_availableList.removeListSelectionListener(this);
        }
        if (this.m_selectedList != null) {
            this.m_selectedList.removeListSelectionListener(this);
        }
        if (this.m_availableList != null) {
            ((VWSortedListModel)this.m_availableList.getModel()).removeAllElements();
            this.m_availableList.setCellRenderer(null);
            this.m_availableList.removeAll();
            this.m_availableList = null;
        }
        if (this.m_selectedList != null) {
            ((VWSortedListModel)this.m_selectedList.getModel()).removeAllElements();
            this.m_selectedList.setCellRenderer(null);
            this.m_selectedList.removeAll();
            this.m_selectedList = null;
        }
        if (this.m_addAllButton != null) {
            this.m_addAllButton.removeActionListener(this);
            this.m_addAllButton = null;
        }
        if (this.m_addButton != null) {
            this.m_addButton.removeActionListener(this);
            this.m_addButton = null;
        }
        if (this.m_removeButton != null) {
            this.m_removeButton.removeActionListener(this);
            this.m_removeButton = null;
        }
        if (this.m_removeAllButton != null) {
            this.m_removeAllButton.removeActionListener(this);
            this.m_removeAllButton = null;
        }
        if (this.m_moveUpButton != null) {
            this.m_moveUpButton.removeActionListener(this);
            this.m_moveUpButton = null;
        }
        if (this.m_moveDownButton != null) {
            this.m_moveDownButton.removeActionListener(this);
            this.m_moveDownButton = null;
        }
        this.m_listUpdateListenerList = null;
        this.m_parentContainer = null;
        this.m_vwSession = null;
        this.removeAll();
    }

    public void addListUpdateListener(IVWListUpdateListener listener) {
        this.m_listUpdateListenerList.add(IVWListUpdateListener.class, listener);
    }

    public void removeListUpdateListener(IVWListUpdateListener listener) {
        this.m_listUpdateListenerList.remove(IVWListUpdateListener.class, listener);
    }

    public void updateItem(Object oldItem, Object newItem) {
        try {
            Object obj;
            int i;
            DefaultListModel availableListModel = (DefaultListModel)this.m_availableList.getModel();
            DefaultListModel selectedListModel = (DefaultListModel)this.m_selectedList.getModel();
            int availableListLen = availableListModel.getSize();
            int selectedListLen = selectedListModel.getSize();
            for (i = 0; i < availableListLen; ++i) {
                obj = availableListModel.getElementAt(i);
                if (!obj.equals(oldItem)) continue;
                availableListModel.setElementAt(newItem, i);
                break;
            }
            for (i = 0; i < selectedListLen; ++i) {
                obj = selectedListModel.getElementAt(i);
                if (!obj.equals(oldItem)) continue;
                selectedListModel.setElementAt(newItem, i);
                break;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public JLabel getAvailableLabel() {
        return this.m_availableLabel;
    }

    public JList getAvailableJList() {
        return this.m_availableList;
    }

    public JLabel getSelectedLabel() {
        return this.m_selectedLabel;
    }

    public JList getSelectedJList() {
        return this.m_selectedList;
    }

    public void forceEnabled(boolean bEnable) {
        try {
            if (bEnable) {
                this.setEnabled(true);
            } else {
                super.setEnabled(false);
                if (this.m_typeAheadName != null) {
                    this.m_typeAheadName.setEditable(false);
                }
                this.m_availableList.setEnabled(false);
                this.m_addButton.setEnabled(false);
                if (this.m_addAllButton != null) {
                    this.m_addAllButton.setEnabled(false);
                }
                if (this.m_removeButton != null) {
                    this.m_removeButton.setEnabled(false);
                }
                if (this.m_removeAllButton != null) {
                    this.m_removeAllButton.setEnabled(false);
                }
                this.m_selectedList.setEnabled(false);
                if (this.m_moveUpButton != null) {
                    this.m_moveUpButton.setEnabled(false);
                }
                if (this.m_moveDownButton != null) {
                    this.m_moveDownButton.setEnabled(false);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setEnabled(boolean bEnable) {
        try {
            super.setEnabled(bEnable);
            this.m_availableList.setEnabled(bEnable);
            this.m_selectedList.setEnabled(bEnable);
            int[] selectedIndices = this.m_availableList.getSelectedIndices();
            int size = this.m_availableList.getModel().getSize();
            this.m_addButton.setEnabled(bEnable && selectedIndices.length > 0);
            this.m_addButton.setFocusable(this.m_addButton.isEnabled());
            if (this.m_typeAheadName != null) {
                this.m_typeAheadName.setEditable(bEnable && size > 0);
                this.m_typeAheadName.setFocusable(this.m_typeAheadName.isEnabled());
            }
            selectedIndices = this.m_selectedList.getSelectedIndices();
            if (this.m_removeButton != null) {
                this.m_removeButton.setEnabled(bEnable && selectedIndices.length > 0);
                this.m_removeButton.setFocusable(this.m_removeButton.isEnabled());
            }
            if (this.m_moveUpButton != null) {
                this.m_moveUpButton.setEnabled(bEnable && selectedIndices.length > 0);
                this.m_moveUpButton.setFocusable(this.m_moveUpButton.isEnabled());
            }
            if (this.m_moveDownButton != null) {
                this.m_moveDownButton.setEnabled(bEnable && selectedIndices.length > 0);
                this.m_moveDownButton.setFocusable(this.m_moveDownButton.isEnabled());
            }
            if (bEnable) {
                this.updateTheAllButtonsState();
            } else {
                if (this.m_addAllButton != null) {
                    this.m_addAllButton.setEnabled(false);
                    this.m_addAllButton.setFocusable(this.m_addAllButton.isEnabled());
                }
                if (this.m_removeAllButton != null) {
                    this.m_removeAllButton.setEnabled(false);
                    this.m_removeAllButton.setFocusable(this.m_removeAllButton.isEnabled());
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource().equals(this.m_availableList)) {
            this.m_selectedList.removeListSelectionListener(this);
            this.m_selectedList.clearSelection();
            this.m_selectedList.addListSelectionListener(this);
            this.updateTheMainButtonsState();
            Object[] selectedObjects = this.m_availableList.getSelectedValues();
            this.fireListUpdatedEvent(5, selectedObjects);
        } else if (event.getSource().equals(this.m_selectedList)) {
            this.m_availableList.removeListSelectionListener(this);
            this.m_availableList.clearSelection();
            this.m_availableList.addListSelectionListener(this);
            this.updateTheMainButtonsState();
            Object[] selectedObjects = this.m_selectedList.getSelectedValues();
            this.fireListUpdatedEvent(6, selectedObjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent event) {
        try {
            this.getRootPane().setCursor(Cursor.getPredefinedCursor(3));
            Object object = event.getSource();
            if (object.equals(this.m_addAllButton) && this.m_addAllButton.isEnabled()) {
                VWSortedListModel listModel = (VWSortedListModel)this.m_availableList.getModel();
                this.m_availableList.removeListSelectionListener(this);
                this.m_availableList.setSelectionInterval(0, listModel.getSize() - 1);
                this.m_availableList.addListSelectionListener(this);
                this.addSelectedItems();
            } else if (object.equals(this.m_addButton) && this.m_addButton.isEnabled()) {
                this.addSelectedItems();
            } else if (object.equals(this.m_removeButton) && this.m_removeButton.isEnabled()) {
                this.removeSelectedItems();
            } else if (object.equals(this.m_removeAllButton) && this.m_removeAllButton.isEnabled()) {
                VWSortedListModel listModel = (VWSortedListModel)this.m_selectedList.getModel();
                this.m_selectedList.removeListSelectionListener(this);
                this.m_selectedList.setSelectionInterval(0, listModel.getSize() - 1);
                this.m_selectedList.addListSelectionListener(this);
                this.removeSelectedItems();
            } else if (object.equals(this.m_moveUpButton) && this.m_moveUpButton.isEnabled()) {
                this.moveSelectedItemsUp();
            } else if (object.equals(this.m_moveDownButton) && this.m_moveDownButton.isEnabled()) {
                this.moveSelectedItemsDown();
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.getRootPane().setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
        this.getRootPane().setCursor(Cursor.getDefaultCursor());
    }

    public void doubleClickedItem(MouseEvent event) {
        Object object = event.getSource();
        if (object.equals(this.m_availableList) && this.m_addButton.isEnabled()) {
            this.addSelectedItems();
        } else if (object.equals(this.m_selectedList) && this.m_removeButton != null && this.m_removeButton.isEnabled()) {
            this.removeSelectedItems();
        }
    }

    public void createPopup(MouseEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUpdate(DocumentEvent event) {
        int selectedIndex = this.m_availableList.getSelectedIndex();
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        try {
            this.getRootPane().setCursor(Cursor.getPredefinedCursor(3));
            int newSelectedIndex = this.returnFirstGreaterIndex(this.m_availableList, this.m_typeAheadName.getText(), selectedIndex);
            this.m_availableList.setSelectedIndex(newSelectedIndex);
            this.m_availableList.ensureIndexIsVisible(newSelectedIndex);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.getRootPane().setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.getRootPane().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void removeUpdate(DocumentEvent event) {
        int newSelectedIndex = this.returnFirstGreaterIndex(this.m_availableList, this.m_typeAheadName.getText(), 0);
        this.m_availableList.setSelectedIndex(newSelectedIndex);
        this.m_availableList.ensureIndexIsVisible(newSelectedIndex);
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
        if (event.getKeyCode() == 10) {
            this.addSelectedItems();
            this.m_typeAheadName.selectAll();
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    public void focusGained(FocusEvent event) {
        int[] indices;
        JList list;
        Object source = event.getSource();
        if (source != null && source instanceof JList && (list = (JList)source).getModel().getSize() > 0 && ((indices = list.getSelectedIndices()) == null || indices.length == 0)) {
            list.setSelectedIndex(0);
        }
    }

    public void focusLost(FocusEvent event) {
    }

    protected void addControls() {
        try {
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(0, 3, 0, 3);
            JPanel panel = this.createAvailableListPanel();
            this.add((Component)panel, gbCons);
            panel.getAccessibleContext().setAccessibleParent(this);
            ++gbCons.gridx;
            gbCons.fill = 3;
            gbCons.weightx = 0.0;
            gbCons.anchor = 10;
            panel = this.createAddRemoveButtonPanel();
            this.add((Component)panel, gbCons);
            panel.getAccessibleContext().setAccessibleParent(this);
            ++gbCons.gridx;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.anchor = 21;
            panel = this.createSelectedListPanel();
            this.add((Component)panel, gbCons);
            panel.getAccessibleContext().setAccessibleParent(this);
            if (this.m_bShowUpDownButtons) {
                ++gbCons.gridx;
                gbCons.fill = 3;
                gbCons.weightx = 0.0;
                panel = this.createMoveUpDownButtonPanel();
                this.add((Component)panel, gbCons);
                panel.getAccessibleContext().setAccessibleParent(this);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel createAvailableListPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 0.5;
        gbCons.weighty = 0.0;
        gbCons.anchor = 21;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)this.m_availableLabel, gbCons);
        if (this.m_enableTypeAhead) {
            ++gbCons.gridy;
            gbCons.insets = new Insets(3, 3, 3, 3);
            this.m_typeAheadName = new JTextField();
            this.m_typeAheadName.getDocument().addDocumentListener(this);
            this.m_typeAheadName.addKeyListener(this);
            this.m_typeAheadName.requestFocus();
            panel.add((Component)this.m_typeAheadName, gbCons);
            VWAccessibilityHelper.setLabelFor(this.m_availableLabel, this.m_typeAheadName);
            this.m_typeAheadName.getAccessibleContext().setAccessibleParent(panel);
            this.m_typeAheadName.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        ++gbCons.gridy;
        gbCons.fill = 1;
        gbCons.weighty = 1.0;
        gbCons.insets = new Insets(0, 3, 0, 3);
        this.m_availableList = new JList(new VWSortedListModel());
        this.m_availableList.addListSelectionListener(this);
        this.m_availableList.addMouseListener(new VWMouseAdapter(this));
        panel.add((Component)new JScrollPane(this.m_availableList), gbCons);
        VWAccessibilityHelper.setAccessibility(this.m_availableList, panel, this.m_availableLabel.getText(), this.m_availableLabel.getText());
        this.m_availableList.addKeyListener(VWKeyAdapter.s_keyAdapter);
        this.m_availableList.addFocusListener(this);
        return panel;
    }

    protected JPanel createSelectedListPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 21;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)this.m_selectedLabel, gbCons);
        ++gbCons.gridy;
        gbCons.fill = 1;
        gbCons.weighty = 1.0;
        gbCons.insets = new Insets(0, 3, 0, 3);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new GridBagLayout());
        panel.add((Component)rightPanel, gbCons);
        GridBagConstraints gbCons2 = new GridBagConstraints();
        gbCons2.anchor = 21;
        gbCons2.fill = 1;
        gbCons2.gridx = 0;
        gbCons2.gridy = 0;
        gbCons2.gridheight = 1;
        gbCons2.gridwidth = 1;
        gbCons2.weightx = 1.0;
        gbCons2.weighty = 1.0;
        gbCons2.insets = new Insets(0, 3, 0, 3);
        this.m_selectedList = new JList(new VWSortedListModel());
        this.m_selectedList.addListSelectionListener(this);
        this.m_selectedList.addMouseListener(new VWMouseAdapter(this));
        rightPanel.add((Component)new JScrollPane(this.m_selectedList), gbCons2);
        VWAccessibilityHelper.setAccessibility(this.m_selectedList, rightPanel, this.m_selectedLabel.getText(), this.m_selectedLabel.getText());
        this.m_selectedList.addKeyListener(VWKeyAdapter.s_keyAdapter);
        this.m_selectedList.addFocusListener(this);
        if (this.m_optionPanel != null) {
            gbCons2.anchor = 21;
            gbCons2.fill = 2;
            gbCons2.gridx = 0;
            gbCons2.gridy = 1;
            gbCons2.gridwidth = 1;
            gbCons2.gridheight = 1;
            gbCons2.weightx = 1.0;
            gbCons2.weighty = 0.0;
            gbCons2.insets = new Insets(6, 3, 0, 3);
            rightPanel.add((Component)this.m_optionPanel, gbCons2);
            this.m_availableList.getAccessibleContext().setAccessibleParent(rightPanel);
        }
        return panel;
    }

    protected JPanel createAddRemoveButtonPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = -1;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 0, 3, 0);
            if (this.m_bShowMoveAllButtons) {
                this.m_addAllButton = new JButton(VWImageLoader.createImageIcon("addall.gif"));
                this.m_addAllButton.setDisabledIcon(VWImageLoader.createImageIcon("addall_d.gif"));
                this.m_addAllButton.setToolTipText(VWResource.s_addAll);
                this.m_addAllButton.setName("m_addAllButton_VWAddRemovePanel");
                this.m_addAllButton.setMargin(new Insets(1, 1, 1, 1));
                this.m_addAllButton.addActionListener(this);
                VWBaseImageLoader.enableIconComponentOrientation(this.m_addAllButton);
                panel.add((Component)this.m_addAllButton, gbCons);
                VWAccessibilityHelper.setAccessibility(this.m_addAllButton, panel, VWResource.s_addAll, VWResource.s_addAll);
                this.m_addAllButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            }
            this.m_addButton = new JButton(VWImageLoader.createImageIcon("add.gif"));
            this.m_addButton.setDisabledIcon(VWImageLoader.createImageIcon("add_d.gif"));
            this.m_addButton.setToolTipText(VWResource.s_add);
            this.m_addButton.setName("m_addButton_VWAddRemovePanel");
            this.m_addButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_addButton.addActionListener(this);
            VWBaseImageLoader.enableIconComponentOrientation(this.m_addButton);
            panel.add((Component)this.m_addButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_addButton, panel, VWResource.s_add, VWResource.s_add);
            this.m_addButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_removeButton = new JButton(VWImageLoader.createImageIcon("remove.gif"));
            this.m_removeButton.setDisabledIcon(VWImageLoader.createImageIcon("remove_d.gif"));
            this.m_removeButton.setToolTipText(VWResource.s_remove);
            this.m_removeButton.setName("m_removeButton_VWAddRemovePanel");
            this.m_removeButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_removeButton.addActionListener(this);
            VWBaseImageLoader.enableIconComponentOrientation(this.m_removeButton);
            panel.add((Component)this.m_removeButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_removeButton, panel, VWResource.s_remove, VWResource.s_remove);
            this.m_removeButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            if (this.m_bShowMoveAllButtons) {
                this.m_removeAllButton = new JButton(VWImageLoader.createImageIcon("removeall.gif"));
                this.m_removeAllButton.setDisabledIcon(VWImageLoader.createImageIcon("removeall_d.gif"));
                this.m_removeAllButton.setToolTipText(VWResource.s_removeAll);
                this.m_removeAllButton.setName("m_removeAllButton_VWAddRemovePanel");
                this.m_removeAllButton.setMargin(new Insets(1, 1, 1, 1));
                this.m_removeAllButton.addActionListener(this);
                VWBaseImageLoader.enableIconComponentOrientation(this.m_removeAllButton);
                panel.add((Component)this.m_removeAllButton, gbCons);
                VWAccessibilityHelper.setAccessibility(this.m_removeAllButton, panel, VWResource.s_removeAll, VWResource.s_removeAll);
                this.m_removeAllButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    protected JPanel createMoveUpDownButtonPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = -1;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 0, 3, 0);
            this.m_moveUpButton = new JButton(VWImageLoader.createImageIcon("up.gif"));
            this.m_moveUpButton.setToolTipText(VWResource.s_moveUp);
            this.m_moveUpButton.setName("m_moveUpButton_VWAddRemovePanel");
            this.m_moveUpButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_moveUpButton.addActionListener(this);
            panel.add((Component)this.m_moveUpButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_moveUpButton, panel, VWResource.s_moveUp, VWResource.s_moveUp);
            this.m_moveUpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_moveDownButton = new JButton(VWImageLoader.createImageIcon("down.gif"));
            this.m_moveDownButton.setToolTipText(VWResource.s_moveDown);
            this.m_moveDownButton.setName("m_moveDownButton_VWAddRemovePanel");
            this.m_moveDownButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_moveDownButton.addActionListener(this);
            panel.add((Component)this.m_moveDownButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_moveDownButton, panel, VWResource.s_moveDown, VWResource.s_moveDown);
            this.m_moveDownButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addSelectedItems() {
        block4: {
            block3: {
                try {
                    this.getRootPane().setCursor(Cursor.getPredefinedCursor(3));
                    Object[] items = this.removeSelectedItems(this.m_availableList);
                    if (items == null) {
                        Object var3_2 = null;
                        break block3;
                    }
                    this.onAddItemsAction(items);
                    this.addSelectedItems(items, this.m_selectedList);
                    this.fireListUpdatedEvent(1, items);
                    this.fireListUpdatedEvent(6, items);
                    this.m_addButton.setEnabled(false);
                    this.m_addButton.setFocusable(this.m_addButton.isEnabled());
                    this.updateTheAllButtonsState();
                    this.m_bIsModified = true;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.getRootPane().setCursor(Cursor.getDefaultCursor());
                    throw throwable;
                }
            }
            this.getRootPane().setCursor(Cursor.getDefaultCursor());
            return;
        }
        Object var3_3 = null;
        this.getRootPane().setCursor(Cursor.getDefaultCursor());
    }

    protected void onAddItemsAction(Object[] items) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addSelectedItems(Object[] items, JList list) {
        block14: {
            block13: {
                try {
                    try {
                        block16: {
                            block15: {
                                this.getRootPane().setCursor(Cursor.getPredefinedCursor(3));
                                if (items == null) break block15;
                                if (items.length != 0) break block16;
                            }
                            Object var9_3 = null;
                            break block13;
                        }
                        VWSortedListModel listModel = (VWSortedListModel)list.getModel();
                        int[] indices = new int[items.length];
                        boolean bPerformMergeSort = false;
                        if (list == this.m_selectedList && (this.m_bSortSelected || this.m_bMaintainSelectedSorted)) {
                            bPerformMergeSort = true;
                        } else if (list == this.m_availableList && (this.m_bSortAvailable || this.m_bMaintainAvailableSorted)) {
                            bPerformMergeSort = true;
                        }
                        if (bPerformMergeSort) {
                            items = listModel.sortArray(items);
                            int startPos = 0;
                            for (int i = 0; i < items.length; ++i) {
                                indices[i] = this.insertToList(listModel, items[i], startPos);
                                startPos = indices[i];
                            }
                        } else {
                            for (int i = 0; i < items.length; ++i) {
                                if (items[i] == null) continue;
                                listModel.addElement(items[i]);
                                indices[i] = listModel.getSize() - 1;
                            }
                        }
                        list.removeListSelectionListener(this);
                        list.setSelectedIndices(indices);
                        this.updateTheMainButtonsState();
                        list.addListSelectionListener(this);
                        break block14;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        Object var9_5 = null;
                        this.getRootPane().setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_6 = null;
                    this.getRootPane().setCursor(Cursor.getDefaultCursor());
                    throw throwable;
                }
            }
            this.getRootPane().setCursor(Cursor.getDefaultCursor());
            return;
        }
        Object var9_4 = null;
        this.getRootPane().setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeSelectedItems() {
        block7: {
            block6: {
                try {
                    this.getRootPane().setCursor(Cursor.getPredefinedCursor(3));
                    Object[] items = this.removeSelectedItems(this.m_selectedList);
                    if (items == null) {
                        Object var7_2 = null;
                        break block6;
                    }
                    VWSortedListModel listModel = (VWSortedListModel)this.m_selectedList.getModel();
                    Vector<Object> itemsToAdd = new Vector<Object>();
                    for (int i = 0; i < items.length; ++i) {
                        int indexInHidden = this.isInArray(listModel, items[i], this.m_hiddenAvailableItems);
                        if (indexInHidden >= 0) continue;
                        itemsToAdd.addElement(items[i]);
                    }
                    items = new Object[itemsToAdd.size()];
                    itemsToAdd.copyInto(items);
                    items = this.onRemoveItemsAction(items);
                    this.addSelectedItems(items, this.m_availableList);
                    this.fireListUpdatedEvent(2, items);
                    this.fireListUpdatedEvent(5, items);
                    if (this.m_removeButton != null) {
                        this.m_removeButton.setEnabled(false);
                        this.m_removeButton.setFocusable(this.m_removeButton.isEnabled());
                    }
                    if (this.m_bShowUpDownButtons) {
                        this.m_moveUpButton.setEnabled(false);
                        this.m_moveDownButton.setFocusable(this.m_moveUpButton.isEnabled());
                    }
                    this.updateTheAllButtonsState();
                    this.m_bIsModified = true;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var7_4 = null;
                    this.getRootPane().setCursor(Cursor.getDefaultCursor());
                    throw throwable;
                }
            }
            this.getRootPane().setCursor(Cursor.getDefaultCursor());
            return;
        }
        Object var7_3 = null;
        this.getRootPane().setCursor(Cursor.getDefaultCursor());
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        return items;
    }

    protected Object[] removeSelectedItems(JList list) {
        try {
            int i;
            int[] indices = list.getSelectedIndices();
            if (indices.length == 0) {
                return null;
            }
            VWSortedListModel listModel = (VWSortedListModel)list.getModel();
            Vector itemVector = new Vector();
            for (i = indices.length - 1; i >= 0; --i) {
                Object item = listModel.getElementAt(indices[i]);
                if (!this.okayToRemoveItem(item)) {
                    indices[i] = -1;
                    continue;
                }
                itemVector.addElement(item);
            }
            for (i = indices.length - 1; i >= 0; --i) {
                int fromIdx;
                int toIdx = fromIdx = indices[i];
                if (fromIdx == -1) continue;
                while (i > 0 && indices[i - 1] == fromIdx - 1) {
                    fromIdx = indices[--i];
                }
                listModel.removeRange(fromIdx, toIdx);
            }
            if (itemVector.size() > 0) {
                list.clearSelection();
                Object[] removedItems = new Object[itemVector.size()];
                itemVector.copyInto(removedItems);
                return removedItems;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    protected boolean okayToRemoveItem(Object item) {
        return true;
    }

    protected void moveSelectedItemsUp() {
        try {
            int[] indices = this.m_selectedList.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            VWSortedListModel listModel = (VWSortedListModel)this.m_selectedList.getModel();
            for (int i = 0; i < indices.length; ++i) {
                Object item = listModel.getElementAt(indices[i]);
                listModel.removeElementAt(indices[i]);
                listModel.add(indices[i] - 1, item);
            }
            this.adjustIndices(indices, -1);
            this.m_selectedList.setSelectedIndices(indices);
            this.m_selectedList.ensureIndexIsVisible(indices[0]);
            this.m_bIsModified = true;
            this.onMoveSelectedItemsUp();
            this.fireListUpdatedEvent(3, null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void onMoveSelectedItemsUp() {
    }

    protected void moveSelectedItemsDown() {
        try {
            int[] indices = this.m_selectedList.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            VWSortedListModel listModel = (VWSortedListModel)this.m_selectedList.getModel();
            for (int i = indices.length - 1; i >= 0; --i) {
                Object item = listModel.getElementAt(indices[i]);
                listModel.removeElementAt(indices[i]);
                listModel.add(indices[i] + 1, item);
            }
            this.adjustIndices(indices, 1);
            this.m_selectedList.setSelectedIndices(indices);
            this.m_selectedList.ensureIndexIsVisible(indices[indices.length - 1]);
            this.m_bIsModified = true;
            this.onMoveSelectedItemsDown();
            this.fireListUpdatedEvent(4, null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void onMoveSelectedItemsDown() {
    }

    protected void updateTheAllButtonsState() {
        if (this.m_bShowMoveAllButtons) {
            if (this.isEnabled()) {
                VWSortedListModel listModel = (VWSortedListModel)this.m_availableList.getModel();
                if (this.m_addAllButton != null) {
                    this.m_addAllButton.setEnabled(listModel.getSize() > 0);
                    this.m_addAllButton.setFocusable(this.m_addAllButton.isEnabled());
                }
                listModel = (VWSortedListModel)this.m_selectedList.getModel();
                if (this.m_removeAllButton != null) {
                    this.m_removeAllButton.setEnabled(listModel.getSize() > 0);
                    this.m_removeAllButton.setFocusable(this.m_removeAllButton.isEnabled());
                }
            } else {
                if (this.m_addAllButton != null) {
                    this.m_addAllButton.setEnabled(false);
                    this.m_addAllButton.setFocusable(this.m_addAllButton.isEnabled());
                }
                if (this.m_removeAllButton != null) {
                    this.m_removeAllButton.setEnabled(false);
                    this.m_removeAllButton.setFocusable(this.m_removeAllButton.isEnabled());
                }
            }
        }
    }

    protected void updateTheMainButtonsState() {
        int[] selectedIndices = this.m_availableList.getSelectedIndices();
        this.m_addButton.setEnabled(selectedIndices.length > 0);
        this.m_addButton.setFocusable(this.m_addButton.isEnabled());
        selectedIndices = this.m_selectedList.getSelectedIndices();
        if (this.m_removeButton != null) {
            this.m_removeButton.setEnabled(selectedIndices.length > 0);
            this.m_removeButton.setFocusable(this.m_removeButton.isEnabled());
        }
        if (this.m_bShowUpDownButtons) {
            if (selectedIndices.length == 0) {
                this.m_moveUpButton.setEnabled(false);
                this.m_moveUpButton.setFocusable(this.m_moveUpButton.isEnabled());
                this.m_moveDownButton.setEnabled(false);
                this.m_moveDownButton.setFocusable(this.m_moveDownButton.isEnabled());
            } else {
                this.m_moveUpButton.setEnabled(selectedIndices[0] != 0);
                this.m_moveUpButton.setFocusable(this.m_moveUpButton.isEnabled());
                ListModel listModel = this.m_selectedList.getModel();
                boolean bEnable = selectedIndices[selectedIndices.length - 1] != listModel.getSize() - 1;
                this.m_moveDownButton.setEnabled(bEnable);
                this.m_moveDownButton.setFocusable(this.m_moveDownButton.isEnabled());
            }
        }
    }

    protected int returnFirstGreaterIndex(JList theList, String typedName, int startingIndex) {
        boolean bFound = false;
        int curNumber = startingIndex;
        try {
            VWSortedListModel listModel = (VWSortedListModel)theList.getModel();
            int nSize = listModel.getSize();
            if (nSize > 0) {
                if (curNumber != 0 && listModel.compare(listModel.getElementAt(curNumber - 1), typedName) >= 0) {
                    curNumber = 0;
                }
                while (!bFound && curNumber < nSize) {
                    if (listModel.compare(listModel.getElementAt(curNumber), typedName) >= 0) {
                        bFound = true;
                        continue;
                    }
                    ++curNumber;
                }
            }
            if (!bFound) {
                --curNumber;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            curNumber = startingIndex;
        }
        return curNumber;
    }

    protected int isInArray(VWSortedListModel listModel, Object item, Object[] items) {
        if (items == null || items.length < 1) {
            return -1;
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || listModel.compare(item, items[i]) != 0) continue;
            return i;
        }
        return -1;
    }

    private void initControls(int nFlags) {
        try {
            this.m_listUpdateListenerList = new EventListenerList();
            if ((nFlags & 0x80) != 0) {
                this.m_enableTypeAhead = true;
            }
            if ((nFlags & 0xA) != 0) {
                this.m_bShowMoveAllButtons = true;
            }
            if ((nFlags & 0x30) != 0) {
                this.m_bShowUpDownButtons = true;
            }
            this.enableSorting(nFlags);
            this.setAvailableItemName(VWResource.s_availableItems);
            this.setSelectedItemName(VWResource.s_selectedItems);
            this.setLayout(new GridBagLayout());
            this.addControls();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void adjustIndices(int[] indices, int nValue) {
        int i = 0;
        while (i < indices.length) {
            int n = i++;
            indices[n] = indices[n] + nValue;
        }
    }

    private void setAvailableAndSelectedItems(Object[] availableItems, Object[] selectedItems) {
        try {
            if (this.m_addButton != null) {
                this.m_addButton.setEnabled(false);
                this.m_addButton.setFocusable(this.m_addButton.isEnabled());
            }
            if (this.m_removeButton != null) {
                this.m_removeButton.setEnabled(false);
                this.m_removeButton.setFocusable(this.m_removeButton.isEnabled());
            }
            if (this.m_moveUpButton != null) {
                this.m_moveUpButton.setEnabled(false);
                this.m_moveUpButton.setFocusable(this.m_moveUpButton.isEnabled());
            }
            if (this.m_moveDownButton != null) {
                this.m_moveDownButton.setEnabled(false);
                this.m_moveDownButton.setFocusable(this.m_moveDownButton.isEnabled());
            }
            VWSortedListModel selectedListModel = (VWSortedListModel)this.m_selectedList.getModel();
            selectedListModel.removeAllElements();
            if (selectedItems != null) {
                for (int i = 0; i < selectedItems.length; ++i) {
                    selectedListModel.addElement(selectedItems[i]);
                }
            }
            VWSortedListModel availableListModel = (VWSortedListModel)this.m_availableList.getModel();
            availableListModel.removeAllElements();
            if (availableItems != null) {
                if (selectedItems == null) {
                    for (int i = 0; i < availableItems.length; ++i) {
                        availableListModel.addElement(availableItems[i]);
                    }
                } else {
                    for (int i = 0; i < availableItems.length; ++i) {
                        int arrayPosition = this.isInArray(availableListModel, availableItems[i], selectedItems);
                        if (arrayPosition != -1) continue;
                        availableListModel.addElement(availableItems[i]);
                    }
                }
            }
            if (this.m_bSortAvailable) {
                availableListModel.sort();
            }
            if (this.m_bSortSelected) {
                selectedListModel.sort();
            }
            this.fireListUpdatedEvent(5, availableItems);
            this.fireListUpdatedEvent(1, selectedItems);
            this.updateTheAllButtonsState();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private int insertToList(VWSortedListModel listModel, Object item, int startPos) {
        int idx = listModel.size();
        for (int i = startPos; i < listModel.size(); ++i) {
            if (listModel.compare(item, listModel.elementAt(i)) >= 0) continue;
            idx = i;
            break;
        }
        listModel.insertElementAt(item, idx);
        return idx;
    }

    protected void fireListUpdatedEvent(int nEventType, Object[] items) {
        this.updateJListFocus();
        Object[] listeners = this.m_listUpdateListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] == null || !listeners[i].equals(IVWListUpdateListener.class)) continue;
            ((IVWListUpdateListener)listeners[i + 1]).listUpdated(this, nEventType, items);
        }
    }

    protected void updateJListFocus() {
        boolean bFocusable;
        boolean bl = bFocusable = this.m_availableList.getModel().getSize() != 0;
        if (bFocusable != this.m_availableList.isFocusable()) {
            this.m_availableList.setFocusable(bFocusable);
        }
        boolean bl2 = bFocusable = this.m_selectedList.getModel().getSize() != 0;
        if (bFocusable != this.m_selectedList.isFocusable()) {
            this.m_selectedList.setFocusable(bFocusable);
        }
        if (bFocusable != this.m_removeButton.isFocusable()) {
            this.m_removeButton.setFocusable(bFocusable);
        }
    }
}

